import React from 'react';
import Image from 'next/image';
import { Button } from 'antd';
import { handlePackageCheck, translate } from '@/utils/helper';
import toast from 'react-hot-toast';
import Swal from 'sweetalert2';
import { useRouter } from 'next/router';
import { PackageTypes } from '@/utils/checkPackages/packageTypes';

const FeaturedPropertyCard = ({ settingsData, propertyId }) => {
    const router = useRouter();
    const adIcon = <svg width="48" height="48" viewBox="0 0 48 48" fill="none" xmlns="http://www.w3.org/2000/svg">
        <path d="M43.4043 44.2822L4.57243 44.1743C2.35149 44.1666 0.553223 42.3542 0.553223 40.1254V5.5059C0.553223 3.2694 2.36686 1.44934 4.59549 1.45706L43.4274 1.56502C45.6483 1.57274 47.4466 3.38508 47.4466 5.61387V40.2334C47.4466 42.4699 45.6329 44.29 43.4043 44.2822Z" fill="#282F39" />
        <path d="M43.4121 44.8381C43.4044 44.8381 43.4044 44.8381 43.3967 44.8381L4.57253 44.7301C2.05187 44.7224 0 42.6556 0 40.126V5.50646C0 4.27252 0.476465 3.11571 1.34486 2.24425C2.21326 1.38049 3.35831 0.902344 4.58021 0.902344H4.59558L43.4198 1.01031C45.9404 1.01803 47.9923 3.08486 47.9923 5.61443V40.234C47.9923 41.4679 47.5159 42.6247 46.6475 43.4962C45.7867 44.3599 44.634 44.8381 43.4121 44.8381ZM4.5879 2.01288C3.65802 2.01288 2.78963 2.37535 2.12872 3.03088C1.46782 3.69412 1.10663 4.57329 1.10663 5.50646V40.126C1.10663 42.0463 2.66667 43.6119 4.58021 43.6196L43.4044 43.7275H43.4121C44.342 43.7275 45.2104 43.3651 45.8713 42.7095C46.5322 42.0463 46.8934 41.1748 46.8934 40.234V5.61443C46.8934 3.69412 45.3333 2.12856 43.4198 2.12085L4.59558 2.01288H4.5879Z" fill="#282F39" />
        <path d="M47.4466 4.71152V39.3233C47.4466 41.5676 45.6329 43.3799 43.4043 43.3722L4.57243 43.2642C2.35149 43.2642 0.553223 41.4519 0.553223 39.2154V4.60356C0.553223 2.35934 2.36686 0.547 4.59549 0.554712L43.4274 0.662681C43.8424 0.662681 44.242 0.724378 44.6109 0.847771C46.2554 1.35677 47.4466 2.89147 47.4466 4.71152Z" fill="var(--primary-color)" />
        <path d="M40.515 37.8899L7.5851 37.967C6.37857 37.967 5.40259 36.9876 5.40259 35.7845V11.6688C5.40259 10.4657 6.37089 9.4863 7.56973 9.4863L40.4996 9.40918C41.7061 9.40918 42.6821 10.3886 42.6821 11.5917V35.7074C42.6898 36.9105 41.7215 37.8822 40.515 37.8899Z" fill="#282F39" />
        <path d="M7.58508 38.5219C6.85501 38.5219 6.17105 38.2365 5.65617 37.7198C5.14128 37.2031 4.85693 36.5168 4.85693 35.7841V11.6684C4.85693 10.1646 6.07884 8.93064 7.57739 8.93064L40.5073 8.85352H40.515C41.245 8.85352 41.929 9.13886 42.4439 9.65557C42.9588 10.1723 43.2431 10.8587 43.2431 11.5913V35.707C43.2431 37.2108 42.0212 38.4448 40.5226 38.4448L7.58508 38.5219ZM40.515 9.96406L7.58508 10.0412C6.69363 10.0412 5.96356 10.7738 5.96356 11.6684V35.7841C5.96356 36.216 6.13263 36.6324 6.44003 36.9332C6.74742 37.2417 7.16241 37.4191 7.59276 37.4114L40.5226 37.3342C41.4141 37.3342 42.1442 36.6016 42.1442 35.707V11.5913C42.1442 11.1594 41.9751 10.743 41.6677 10.4422C41.3526 10.1337 40.9453 9.96406 40.515 9.96406Z" fill="#282F39" />
        <path d="M40.515 38.344L7.5851 38.4211C6.37857 38.4211 5.40259 37.4417 5.40259 36.2386V12.1229C5.40259 10.9198 6.37089 9.9404 7.56973 9.9404L40.4996 9.86328C41.7061 9.86328 42.6821 10.8427 42.6821 12.0458V36.1615C42.6898 37.3646 41.7215 38.344 40.515 38.344Z" fill="white" />
        <path d="M43.4121 43.928C43.4044 43.928 43.4044 43.928 43.3967 43.928L4.57253 43.82C2.05187 43.8123 0 41.7455 0 39.2159V4.60411C0 3.37018 0.476465 2.21337 1.34486 1.3419C2.21326 0.478149 3.36599 0 4.5879 0H4.60327L43.4275 0.107969C45.9481 0.115681 48 2.18252 48 4.71208V39.3316C48 40.5655 47.5235 41.7224 46.6551 42.5938C45.7867 43.4499 44.634 43.928 43.4121 43.928ZM43.4044 42.8175C44.3497 42.8175 45.2104 42.455 45.8713 41.7995C46.5322 41.1362 46.8934 40.2648 46.8934 39.3239V4.71208C46.8934 2.79177 45.3333 1.22622 43.4198 1.21851L4.59558 1.11054C3.68108 1.11054 2.78963 1.47301 2.12872 2.12853C1.46782 2.78406 1.10663 3.67095 1.10663 4.60411V39.2236C1.10663 41.144 2.66667 42.7095 4.58021 42.7172L43.4044 42.8175Z" fill="#282F39" />
        <path d="M7.58508 39.4242C6.85501 39.4242 6.17105 39.1389 5.65617 38.6222C5.14128 38.1055 4.85693 37.4191 4.85693 36.6865V12.5708C4.85693 11.0669 6.07884 9.83298 7.57739 9.83298L40.5073 9.75586H40.515C41.245 9.75586 41.929 10.0412 42.4439 10.5579C42.9588 11.0746 43.2431 11.761 43.2431 12.4936V36.6093C43.2431 38.1132 42.0212 39.3471 40.5226 39.3471L7.58508 39.4242ZM40.515 10.8741L7.58508 10.9512C6.69363 10.9512 5.96356 11.6839 5.96356 12.5785V36.6942C5.96356 37.126 6.13263 37.5425 6.44003 37.8433C6.74742 38.1517 7.15472 38.3214 7.58508 38.3214L40.515 38.2443C41.4064 38.2443 42.1365 37.5116 42.1365 36.617V12.5014C42.1365 12.0695 41.9674 11.653 41.66 11.3523C41.3526 11.0361 40.9453 10.8741 40.515 10.8741Z" fill="#282F39" />
        <path d="M7.1624 6.30831C7.68498 6.87129 8.54569 7.09494 9.27576 6.85587C10.0058 6.61679 10.5668 5.92271 10.636 5.1515C10.7052 4.38029 10.2594 3.59366 9.57547 3.26204C7.70035 2.35201 5.64848 4.69649 7.1624 6.30831Z" fill="white" />
        <path d="M8.67624 7.51163C7.96923 7.51163 7.25453 7.21857 6.7627 6.69415C5.93273 5.80726 5.85588 4.59646 6.57826 3.61703C7.20843 2.75328 8.49181 2.1286 9.81361 2.7687C10.7127 3.20058 11.2737 4.21086 11.1892 5.20572C11.1047 6.18515 10.39 7.07975 9.45242 7.38824C9.19882 7.47307 8.93753 7.51163 8.67624 7.51163ZM8.6993 3.61703C8.18441 3.61703 7.72331 3.91009 7.46203 4.27256C7.31601 4.48078 6.87797 5.19801 7.56193 5.93065C7.94618 6.33939 8.57634 6.50135 9.09891 6.33168C9.62149 6.16202 10.0288 5.64531 10.0749 5.10546C10.121 4.5579 9.80593 3.99492 9.32178 3.76356C9.11428 3.6633 8.90679 3.61703 8.6993 3.61703Z" fill="#282F39" />
        <path d="M15.6694 6.30831C16.192 6.87129 17.0527 7.09494 17.7828 6.85587C18.5129 6.61679 19.0739 5.92271 19.143 5.1515C19.2122 4.38029 18.7665 3.59366 18.0825 3.26204C16.2074 2.35201 14.1632 4.69649 15.6694 6.30831Z" fill="#FFC94D" />
        <path d="M17.1833 7.51163C16.4763 7.51163 15.7616 7.21857 15.2698 6.69415C14.4398 5.80726 14.363 4.59646 15.0853 3.61703C15.7155 2.75328 16.9989 2.1286 18.3207 2.7687C19.2198 3.20058 19.7808 4.21086 19.6963 5.20572C19.6118 6.18515 18.8971 7.07975 17.9595 7.38824C17.7059 7.47307 17.4446 7.51163 17.1833 7.51163ZM17.2141 3.61703C16.6992 3.61703 16.2381 3.91009 15.9768 4.27256C15.8308 4.48078 15.3927 5.19801 16.0767 5.93065C16.4609 6.33939 17.0911 6.50135 17.6137 6.33168C18.1363 6.16202 18.5436 5.64531 18.5897 5.10546C18.6358 4.5579 18.3207 3.99492 17.8365 3.76356C17.6214 3.6633 17.4139 3.61703 17.2141 3.61703Z" fill="#282F39" />
        <path d="M24.1844 6.30831C24.707 6.87129 25.5677 7.09494 26.2978 6.85587C27.0279 6.61679 27.5889 5.92271 27.658 5.1515C27.7272 4.38029 27.2815 3.59366 26.5975 3.26204C24.7147 2.35201 22.6705 4.69649 24.1844 6.30831Z" fill="white" />
        <path d="M25.6906 7.51163C24.9836 7.51163 24.2689 7.21857 23.7771 6.69415C22.9471 5.80726 22.8703 4.59646 23.5927 3.61703C24.2228 2.75328 25.5062 2.1286 26.828 2.7687C27.7272 3.20058 28.2882 4.21086 28.2036 5.20572C28.1191 6.18515 27.4044 7.07975 26.4668 7.38824C26.2132 7.47307 25.9519 7.51163 25.6906 7.51163ZM24.584 5.93065C24.9683 6.33939 25.5984 6.50135 26.121 6.33168C26.6436 6.16202 27.0509 5.64531 27.097 5.10546C27.1431 4.5579 26.828 3.99492 26.3439 3.76356C25.5907 3.39338 24.8453 3.77127 24.4841 4.27256C24.3304 4.47307 23.9001 5.19801 24.584 5.93065Z" fill="#282F39" />
        <path d="M23.7464 29.9923C23.5389 29.9923 23.3391 29.8766 23.2469 29.6761C22.2863 27.6401 21.3103 25.5038 20.365 23.4293C19.6042 21.7557 18.8127 20.0282 18.0365 18.3547L13.5946 29.5989C13.4793 29.8843 13.1566 30.0231 12.8722 29.9074C12.5879 29.7917 12.4496 29.4678 12.5648 29.1825L17.4755 16.7429C17.56 16.5347 17.7522 16.3958 17.975 16.3958C18.1902 16.3881 18.3977 16.5115 18.4899 16.712C19.4505 18.748 20.4265 20.8843 21.3717 22.9588C22.317 25.0257 23.293 27.1619 24.2459 29.1902C24.3766 29.4678 24.2613 29.7994 23.9846 29.9306C23.9078 29.9768 23.8309 29.9923 23.7464 29.9923Z" fill="#282F39" />
        <path d="M21.9635 26.3821C21.9174 26.3821 21.8713 26.3744 21.8252 26.3667C19.6811 25.8037 17.4678 25.6032 15.2623 25.7652C14.9549 25.7806 14.6936 25.5569 14.6705 25.2484C14.6475 24.94 14.878 24.6778 15.1854 24.6546C17.5216 24.4849 19.8502 24.6932 22.1172 25.2947C22.4092 25.3718 22.5937 25.6726 22.5091 25.9734C22.4323 26.2125 22.2094 26.3821 21.9635 26.3821Z" fill="#282F39" />
        <path d="M29.5025 29.5758C29.3488 29.5758 29.1951 29.5604 29.0414 29.5295C28.1884 29.3676 27.3968 28.7506 26.928 27.8868C26.5745 27.2313 26.3824 26.437 26.3363 25.4421C26.2825 24.3007 26.4439 23.2981 26.8051 22.4575C27.2585 21.401 28.0654 20.5912 29.0183 20.2287C29.8406 19.9125 31.2393 20.0745 32.2229 20.5141C32.2076 19.1722 32.1384 17.838 32.0078 16.5115C31.977 16.203 32.1999 15.9331 32.5073 15.9023C32.807 15.8714 33.0836 16.0951 33.1144 16.4035C33.368 19.0257 33.4064 21.694 33.222 24.3238C33.1451 25.4344 33.0068 26.6992 32.3766 27.7789C31.7234 28.8817 30.5937 29.5758 29.5025 29.5758ZM30.0558 21.1696C29.8022 21.1696 29.5793 21.2005 29.4103 21.2622C28.734 21.5244 28.1576 22.1182 27.8118 22.8971C27.5198 23.5758 27.3891 24.4164 27.4352 25.3881C27.4737 26.2056 27.6197 26.8457 27.8963 27.347C28.2114 27.9254 28.7109 28.3341 29.2412 28.4344C30.1019 28.5963 30.9857 27.9408 31.4083 27.2159C31.9155 26.3444 32.0308 25.2647 32.1 24.239C32.1538 23.4293 32.1922 22.6118 32.2076 21.7943C31.8233 21.4318 30.8166 21.1696 30.0558 21.1696Z" fill="#282F39" />
        <path d="M34.3131 28.4805C33.9442 28.4805 33.583 28.4033 33.2449 28.2491C32.6301 27.9715 32.1383 27.4548 31.8924 26.8224C31.7771 26.537 31.9231 26.2131 32.2074 26.1051C32.4918 25.9895 32.8146 26.136 32.9221 26.4213C33.0605 26.7761 33.3525 27.0846 33.6983 27.2388C34.0441 27.3931 34.4668 27.4085 34.8203 27.2774C35.1047 27.1694 35.4274 27.3237 35.5273 27.609C35.6349 27.8943 35.4812 28.2183 35.1969 28.3185C34.9202 28.4342 34.6205 28.4805 34.3131 28.4805Z" fill="#282F39" />
        <g opacity="0.1">
            <path d="M47.4466 4.71218V39.324C47.4466 41.5682 45.6329 43.3806 43.4043 43.3728L4.57243 43.2649C2.35149 43.2649 0.553223 41.4525 0.553223 39.216V25.7045C1.16033 25.9358 1.77512 26.1441 2.40529 26.3137C5.69443 27.2392 9.14496 27.432 12.5571 27.4628C17.1911 27.5014 21.8942 27.2392 26.2977 25.7893C32.8145 23.6531 38.4245 18.8793 41.5984 12.7867C43.5119 9.11578 44.534 4.98211 44.6032 0.833008C46.2554 1.35743 47.4466 2.89213 47.4466 4.71218Z" fill="#282F39" />
        </g>
        <path d="M27.366 37.1421L25.3679 38.029C25.0528 38.1678 24.9068 38.5457 25.0528 38.8619L28.0039 45.2552C28.1499 45.5714 28.0039 45.957 27.6811 46.0882L24.6148 47.3915C24.3074 47.5226 23.9462 47.3838 23.8079 47.083L20.8569 40.6974C20.7109 40.3889 20.3497 40.2501 20.0423 40.3889L17.9597 41.3144C17.5216 41.5072 17.0375 41.1524 17.0913 40.6743C17.4371 37.5894 17.7906 34.5046 18.1364 31.4198C18.1902 30.9648 18.6897 30.718 19.074 30.9648C21.8252 32.6768 24.6609 34.3349 27.4198 36.0393C27.8655 36.3015 27.8194 36.9339 27.366 37.1421Z" fill="#282F39" />
        <path d="M24.3842 48.0009C23.9384 48.0009 23.5234 47.7464 23.3236 47.3146L20.3726 40.929C20.3573 40.8981 20.3188 40.8827 20.2881 40.8981L18.2055 41.8236C17.8136 41.9932 17.3755 41.947 17.0374 41.6925C16.6916 41.438 16.5148 41.0369 16.5686 40.6128L17.6137 31.3583C17.6599 30.9572 17.9058 30.6102 18.267 30.4328C18.6282 30.2554 19.0508 30.2786 19.3966 30.4945C20.7953 31.366 22.2478 32.2374 23.6464 33.0781C24.9913 33.8878 26.3899 34.7284 27.7425 35.5691C28.1113 35.8004 28.3265 36.2169 28.2958 36.6488C28.265 37.0883 27.9961 37.4739 27.5965 37.6513L25.6061 38.5382C25.5907 38.5459 25.5753 38.5613 25.5676 38.5768C25.56 38.5922 25.56 38.6153 25.5676 38.6308L28.5186 45.0241C28.657 45.3171 28.6647 45.641 28.5494 45.9418C28.4341 46.2426 28.2112 46.4739 27.9115 46.6051L24.8453 47.9084C24.6916 47.9701 24.5379 48.0009 24.3842 48.0009ZM20.3035 39.7799C20.7492 39.7799 21.1795 40.0344 21.3717 40.4585L24.3227 46.8441C24.338 46.875 24.3765 46.8904 24.4072 46.875L27.4735 45.5716C27.4889 45.5639 27.5042 45.5485 27.5119 45.5331C27.5196 45.5176 27.5196 45.4945 27.5119 45.4791L24.5609 39.0858C24.4303 38.7927 24.4149 38.4765 24.5302 38.1757C24.6454 37.875 24.8606 37.6436 25.1526 37.5125L27.143 36.6256C27.1507 36.6179 27.1815 36.6102 27.1815 36.5639C27.1815 36.5254 27.1584 36.5099 27.1507 36.5022C25.8059 35.6693 24.4149 34.8287 23.07 34.0189C21.6637 33.1706 20.2112 32.2991 18.8049 31.42C18.7972 31.4122 18.7742 31.3968 18.7434 31.4122C18.7127 31.4277 18.7127 31.4508 18.705 31.4662L17.6599 40.7207C17.6599 40.7284 17.6522 40.7593 17.6906 40.7824C17.7213 40.8056 17.7444 40.7979 17.7598 40.7901L19.8424 39.8647C19.9884 39.8184 20.1498 39.7799 20.3035 39.7799Z" fill="#282F39" />
        <path d="M27.9961 36.8492L25.9981 37.7361C25.683 37.8749 25.537 38.2528 25.683 38.569L28.634 44.9623C28.78 45.2785 28.634 45.6641 28.3112 45.7952L25.2449 47.0985C24.9375 47.2296 24.5763 47.0908 24.438 46.79L21.487 40.4044C21.341 40.096 20.9798 39.9571 20.6724 40.096L18.5898 41.0214C18.1518 41.2142 17.6676 40.8595 17.7214 40.3813C18.0672 37.2965 18.4207 34.2116 18.7665 31.1268C18.8203 30.6718 19.3199 30.425 19.7041 30.6718C22.4553 32.3839 25.291 34.042 28.0499 35.7463C28.5033 36.0085 28.4572 36.6409 27.9961 36.8492Z" fill="#FFC94D" />
        <path d="M25.0144 47.708C24.5687 47.708 24.1537 47.4535 23.9539 47.0216L21.0029 40.636C20.9875 40.6051 20.9491 40.5897 20.9107 40.6051L18.828 41.5306C18.4361 41.7003 17.9981 41.654 17.6599 41.3995C17.3141 41.145 17.1374 40.744 17.1912 40.3198L18.2363 31.0653C18.2824 30.6643 18.5283 30.3172 18.8895 30.1398C19.2507 29.9625 19.6734 29.9856 20.0192 30.2015C21.4179 31.073 22.8703 31.9445 24.269 32.7851C25.6138 33.5949 27.0125 34.4355 28.365 35.2761C28.7339 35.5075 28.9491 35.9239 28.9183 36.3558C28.8876 36.7954 28.6186 37.181 28.219 37.3584L26.2209 38.2452C26.2056 38.253 26.1902 38.2684 26.1825 38.2838C26.1748 38.2992 26.1748 38.3224 26.1825 38.3378L29.1335 44.7311C29.2718 45.0242 29.2795 45.3481 29.1643 45.6488C29.049 45.9496 28.8261 46.181 28.5264 46.3121L25.4601 47.6154C25.3218 47.6771 25.1681 47.708 25.0144 47.708ZM20.9337 39.4869C21.3794 39.4869 21.8098 39.7414 22.0019 40.1656L24.9529 46.5512C24.9683 46.582 25.0067 46.5974 25.0375 46.582L28.1037 45.2787C28.1191 45.2709 28.1345 45.2555 28.1422 45.2401C28.1498 45.2247 28.1498 45.2015 28.1422 45.1861L25.1912 38.7928C25.0605 38.4997 25.0451 38.1835 25.1604 37.8828C25.2757 37.582 25.4909 37.3506 25.7829 37.2195L27.781 36.3326C27.7887 36.3249 27.8194 36.3172 27.8194 36.2709C27.8194 36.2324 27.7963 36.217 27.7887 36.2093C26.4438 35.3763 25.0528 34.5357 23.708 33.726C22.3016 32.8776 20.8492 32.0062 19.4428 31.127C19.4352 31.1193 19.4121 31.1039 19.3814 31.1193C19.3506 31.1347 19.3506 31.1578 19.3429 31.1733L18.2978 40.4278C18.2978 40.4355 18.2901 40.4663 18.3285 40.4895C18.3593 40.5126 18.3823 40.5049 18.3977 40.4972L20.4803 39.5717C20.6186 39.5254 20.78 39.4869 20.9337 39.4869Z" fill="#282F39" />
        <path d="M39.2163 5.5065H32.0463C31.7927 5.5065 31.5852 5.29828 31.5852 5.04378C31.5852 4.78928 31.7927 4.58105 32.0463 4.58105H39.2163C39.4699 4.58105 39.6774 4.78928 39.6774 5.04378C39.6774 5.29828 39.4699 5.5065 39.2163 5.5065Z" fill="white" />
        <path d="M42.3287 5.5065H41.8522C41.5986 5.5065 41.3911 5.29828 41.3911 5.04378C41.3911 4.78928 41.5986 4.58105 41.8522 4.58105H42.3287C42.5823 4.58105 42.7898 4.78928 42.7898 5.04378C42.7898 5.29828 42.59 5.5065 42.3287 5.5065Z" fill="white" />
    </svg>

    const handleFeatureClick = (e) => {
        if (settingsData.demo_mode === true) {
            Swal.fire({
                title: translate("opps"),
                text: translate("notAllowdDemo"),
                icon: "warning",
                showCancelButton: false,
                customClass: {
                    confirmButton: "Swal-buttons",
                },
                confirmButtonText: translate("ok"),
            });
            return false;
        }
        handlePackageCheck(e, PackageTypes.PROPERTY_FEATURE, router);
    };

    return (
        <div className="featured-property-card">
            <div className="card_header">
                <h2>{translate("featuredAdProperty")}</h2>
            </div>

            <div className="featured-content">
                <div className="featured-icon">
                    {adIcon}
                </div>
                <p>{translate("dontWaitFeatureText")}</p>

            </div>
            <div className="featured-footer">
                <button
                    onClick={handleFeatureClick}
                    className="feature-button"
                >
                    {translate("featured")}
                </button>
            </div>
        </div>
    );
};

export default FeaturedPropertyCard;
